/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.util;

import java.lang.reflect.Field;
import java.util.Properties;
import org.mariadb.jdbc.internal.util.OptionUtils;
import org.mariadb.jdbc.internal.util.Options;
import org.mariadb.jdbc.internal.util.constant.HaMode;

public final class DefaultOptions
extends Enum<DefaultOptions> {
    public static final /* enum */ DefaultOptions USER = new DefaultOptions("user", "1.0.0", "Database user name", false);
    public static final /* enum */ DefaultOptions PASSWORD = new DefaultOptions("password", "1.0.0", "Password of database user", false);
    public static final /* enum */ DefaultOptions CONNECT_TIMEOUT = new DefaultOptions("connectTimeout", 30000, (Integer)0, "1.1.8", "The connect timeout value, in milliseconds, or zero for no timeout.", false);
    public static final /* enum */ DefaultOptions PIPE = new DefaultOptions("pipe", "1.1.3", "On Windows, specify named pipe name to connect.", false);
    public static final /* enum */ DefaultOptions LOCAL_SOCKET = new DefaultOptions("localSocket", "1.1.4", "Permits connecting to the database via Unix domain socket, if the server allows it. \nThe value is the path of Unix domain socket (i.e \"socket\" database parameter : select @@socket).", false);
    public static final /* enum */ DefaultOptions SHARED_MEMORY = new DefaultOptions("sharedMemory", "1.1.4", "Permits connecting to the database via shared memory, if the server allows it. \nThe value is the base name of the shared memory.", false);
    public static final /* enum */ DefaultOptions TCP_NO_DELAY = new DefaultOptions("tcpNoDelay", Boolean.TRUE, "1.0.0", "Sets corresponding option on the connection socket.", false);
    public static final /* enum */ DefaultOptions TCP_ABORTIVE_CLOSE = new DefaultOptions("tcpAbortiveClose", Boolean.FALSE, "1.1.1", "Sets corresponding option on the connection socket.", false);
    public static final /* enum */ DefaultOptions LOCAL_SOCKET_ADDRESS = new DefaultOptions("localSocketAddress", "1.1.8", "Hostname or IP address to bind the connection socket to a local (UNIX domain) socket.", false);
    public static final /* enum */ DefaultOptions SOCKET_TIMEOUT = new DefaultOptions("socketTimeout", new Integer[]{10000, null, null, null, null, null}, (Integer)0, "1.1.8", "Defined the network socket timeout (SO_TIMEOUT) in milliseconds. Value of 0 disables this timeout. \nIf the goal is to set a timeout for all queries, since MariaDB 10.1.1, the server has permitted a solution to limit the query time by setting a system variable, max_statement_time. The advantage is that the connection then is still usable.\nDefault: 0 (standard configuration) or 10000ms (using \"aurora\" failover configuration).", false);
    public static final /* enum */ DefaultOptions INTERACTIVE_CLIENT = new DefaultOptions("interactiveClient", Boolean.FALSE, "1.1.8", "Session timeout is defined by the wait_timeout server variable. Setting interactiveClient to true will tell the server to use the interactive_timeout server variable.", false);
    public static final /* enum */ DefaultOptions DUMP_QUERY_ON_EXCEPTION = new DefaultOptions("dumpQueriesOnException", Boolean.FALSE, "1.1.0", "If set to 'true', an exception is thrown during query execution containing a query string.", false);
    public static final /* enum */ DefaultOptions USE_OLD_ALIAS_METADATA_BEHAVIOR = new DefaultOptions("useOldAliasMetadataBehavior", Boolean.FALSE, "1.1.9", "Metadata ResultSetMetaData.getTableName() returns the physical table name. \"useOldAliasMetadataBehavior\" permits activating the legacy code that sends the table alias if set.", false);
    public static final /* enum */ DefaultOptions ALLOW_LOCAL_INFILE = new DefaultOptions("allowLocalInfile", Boolean.TRUE, "1.2.1", "Permit loading data from file", false);
    public static final /* enum */ DefaultOptions SESSION_VARIABLES = new DefaultOptions("sessionVariables", "1.1.0", "<var>=<value> pairs separated by comma, mysql session variables, set upon establishing successful connection.", false);
    public static final /* enum */ DefaultOptions CREATE_DATABASE_IF_NOT_EXISTS = new DefaultOptions("createDatabaseIfNotExist", Boolean.FALSE, "1.1.8", "the specified database in the url will be created if non-existent.", false);
    public static final /* enum */ DefaultOptions SERVER_TIMEZONE = new DefaultOptions("serverTimezone", "1.1.8", "Defines the server time zone.\nto use only if the jre server has a different time implementation of the server.\n(best to have the same server time zone when possible).", false);
    public static final /* enum */ DefaultOptions NULL_CATALOG_MEANS_CURRENT = new DefaultOptions("nullCatalogMeansCurrent", Boolean.TRUE, "1.1.8", "DatabaseMetaData use current catalog if null.", false);
    public static final /* enum */ DefaultOptions TINY_INT_IS_BIT = new DefaultOptions("tinyInt1isBit", Boolean.TRUE, "1.0.0", "Datatype mapping flag, handle Tiny as BIT(boolean).", false);
    public static final /* enum */ DefaultOptions YEAR_IS_DATE_TYPE = new DefaultOptions("yearIsDateType", Boolean.TRUE, "1.0.0", "Year is date type, rather than numerical.", false);
    public static final /* enum */ DefaultOptions USE_SSL = new DefaultOptions("useSsl", Boolean.FALSE, "1.1.0", "Force SSL on connection. (legacy alias \"useSSL\")", false);
    public static final /* enum */ DefaultOptions USER_COMPRESSION = new DefaultOptions("useCompression", Boolean.FALSE, "1.0.0", "Compresses the exchange with the database through gzip. This permits better performance when the database is not in the same location.", false);
    public static final /* enum */ DefaultOptions ALLOW_MULTI_QUERIES = new DefaultOptions("allowMultiQueries", Boolean.FALSE, "1.0.0", "permit multi-queries like insert into ab (i) values (1); insert into ab (i) values (2).", false);
    public static final /* enum */ DefaultOptions REWRITE_BATCHED_STATEMENTS = new DefaultOptions("rewriteBatchedStatements", Boolean.FALSE, "1.1.8", "For insert queries, rewrite batchedStatement to execute in a single executeQuery.\nexample:\n   insert into ab (i) values (?) with first batch values = 1, second = 2 will be rewritten\n   insert into ab (i) values (1), (2). \n\nIf query cannot be rewriten in \"multi-values\", rewrite will use multi-queries : INSERT INTO TABLE(col1) VALUES (?) ON DUPLICATE KEY UPDATE col2=? with values [1,2] and [2,3]\" will be rewritten\nINSERT INTO TABLE(col1) VALUES (1) ON DUPLICATE KEY UPDATE col2=2;INSERT INTO TABLE(col1) VALUES (3) ON DUPLICATE KEY UPDATE col2=4\n\nwhen active, the useServerPrepStmts option is set to false", false);
    public static final /* enum */ DefaultOptions TCP_KEEP_ALIVE = new DefaultOptions("tcpKeepAlive", Boolean.TRUE, "1.0.0", "Sets corresponding option on the connection socket.", false);
    public static final /* enum */ DefaultOptions TCP_RCV_BUF = new DefaultOptions("tcpRcvBuf", (Integer)null, (Integer)0, "1.0.0", "set buffer size for TCP buffer (SO_RCVBUF).", false);
    public static final /* enum */ DefaultOptions TCP_SND_BUF = new DefaultOptions("tcpSndBuf", (Integer)null, (Integer)0, "1.0.0", "set buffer size for TCP buffer (SO_SNDBUF).", false);
    public static final /* enum */ DefaultOptions SOCKET_FACTORY = new DefaultOptions("socketFactory", "1.0.0", "to use a custom socket factory, set it to the full name of the class that implements javax.net.SocketFactory.", false);
    public static final /* enum */ DefaultOptions PIN_GLOBAL_TX_TO_PHYSICAL_CONNECTION = new DefaultOptions("pinGlobalTxToPhysicalConnection", Boolean.FALSE, "1.1.8", "", false);
    public static final /* enum */ DefaultOptions TRUST_SERVER_CERTIFICATE = new DefaultOptions("trustServerCertificate", Boolean.FALSE, "1.1.1", "When using SSL, do not check server's certificate.", false);
    public static final /* enum */ DefaultOptions SERVER_SSL_CERT = new DefaultOptions("serverSslCert", "1.1.3", "Permits providing server's certificate in DER form, or server's CA certificate. The server will be added to trustStor. This permits a self-signed certificate to be trusted.\nCan be used in one of 3 forms : \n* serverSslCert=/path/to/cert.pem (full path to certificate)\n* serverSslCert=classpath:relative/cert.pem (relative to current classpath)\n* or as verbatim DER-encoded certificate string \"------BEGIN CERTIFICATE-----\" .", false);
    public static final /* enum */ DefaultOptions USE_FRACTIONAL_SECONDS = new DefaultOptions("useFractionalSeconds", Boolean.TRUE, "1.0.0", "Correctly handle subsecond precision in timestamps (feature available with MariaDB 5.3 and later).\nMay confuse 3rd party components (Hibernate).", false);
    public static final /* enum */ DefaultOptions AUTO_RECONNECT = new DefaultOptions("autoReconnect", Boolean.FALSE, "1.2.0", "Driver must recreateConnection after a failover.", false);
    public static final /* enum */ DefaultOptions FAIL_ON_READ_ONLY = new DefaultOptions("failOnReadOnly", Boolean.FALSE, "1.2.0", "After a master failover and no other master found, back on a read-only host ( throw exception if not).", false);
    public static final /* enum */ DefaultOptions RETRY_ALL_DOWN = new DefaultOptions("retriesAllDown", 120, (Integer)0, "1.2.0", "When using loadbalancing, the number of times the driver should cycle through available hosts, attempting to connect.\n     * Between cycles, the driver will pause for 250ms if no servers are available.", false);
    public static final /* enum */ DefaultOptions FAILOVER_LOOP_RETRIES = new DefaultOptions("failoverLoopRetries", 120, (Integer)0, "1.2.0", "When using failover, the number of times the driver should cycle silently through available hosts, attempting to connect.\n     * Between cycles, the driver will pause for 250ms if no servers are available.\n     * if set to 0, there will be no silent reconnection", false);
    public static final /* enum */ DefaultOptions VALID_CONNECTION_TIMEOUT = new DefaultOptions("validConnectionTimeout", 0, (Integer)0, "1.2.0", "When in multiple hosts, after this time in second without used, verification that the connections haven't been lost.\n     * When 0, no verification will be done. Defaults to 0 (120 before 1.5.8 version)", false);
    public static final /* enum */ DefaultOptions LOAD_BALANCE_BLACKLIST_TIMEOUT = new DefaultOptions("loadBalanceBlacklistTimeout", 50, (Integer)0, "1.2.0", "time in second a server is blacklisted after a connection failure.", false);
    public static final /* enum */ DefaultOptions CACHE_PREP_STMTS = new DefaultOptions("cachePrepStmts", Boolean.TRUE, "1.3.0", "enable/disable prepare Statement cache, default true.", false);
    public static final /* enum */ DefaultOptions PREP_STMT_CACHE_SIZE = new DefaultOptions("prepStmtCacheSize", 250, (Integer)0, "1.3.0", "This sets the number of prepared statements that the driver will cache per connection if \"cachePrepStmts\" is enabled.", false);
    public static final /* enum */ DefaultOptions PREP_STMT_CACHE_SQL_LIMIT = new DefaultOptions("prepStmtCacheSqlLimit", 2048, (Integer)0, "1.3.0", "This is the maximum length of a prepared SQL statement that the driver will cache  if \"cachePrepStmts\" is enabled.", false);
    public static final /* enum */ DefaultOptions ASSURE_READONLY = new DefaultOptions("assureReadOnly", Boolean.FALSE, "1.3.0", "If true, in high availability, and switching to a read-only host, assure that this host is in read-only mode by setting the session to read-only.", false);
    public static final /* enum */ DefaultOptions USE_LEGACY_DATETIME_CODE = new DefaultOptions("useLegacyDatetimeCode", Boolean.TRUE, "1.3.0", "if true (default) store date/timestamps according to client time zone.\nif false, store all date/timestamps in DB according to server time zone, and time information (that is a time difference), doesn't take\ntimezone in account.", false);
    public static final /* enum */ DefaultOptions MAXIMIZE_MYSQL_COMPATIBILITY = new DefaultOptions("maximizeMysqlCompatibility", Boolean.FALSE, "1.3.0", "maximize MySQL compatibility.\nwhen using jdbc setDate(), will store date in client timezone, not in server timezone when useLegacyDatetimeCode = false.\ndefault to false.", false);
    public static final /* enum */ DefaultOptions USE_SERVER_PREP_STMTS = new DefaultOptions("useServerPrepStmts", Boolean.FALSE, "1.3.0", "useServerPrepStmts must prepared statements be prepared on server side, or just faked on client side.\n     * if rewriteBatchedStatements is set to true, this options will be set to false.", false);
    public static final /* enum */ DefaultOptions TRUSTSTORE = new DefaultOptions("trustStore", "1.3.0", "File path of the trustStore file (similar to java System property \"javax.net.ssl.trustStore\"). (legacy alias trustCertificateKeyStoreUrl)\nUse the specified file for trusted root certificates.\nWhen set, overrides serverSslCert.", false);
    public static final /* enum */ DefaultOptions TRUST_CERTIFICATE_KEYSTORE_PASSWORD = new DefaultOptions("trustStorePassword", "1.3.0", "Password for the trusted root certificate file (similar to java System property \"javax.net.ssl.trustStorePassword\").\n(legacy alias trustCertificateKeyStorePassword).", false);
    public static final /* enum */ DefaultOptions KEYSTORE = new DefaultOptions("keyStore", "1.3.0", "File path of the keyStore file that contain client private key store and associate certificates (similar to java System property \"javax.net.ssl.keyStore\", but ensure that only the private key's entries are used).(legacy alias clientCertificateKeyStoreUrl).", false);
    public static final /* enum */ DefaultOptions KEYSTORE_PASSWORD = new DefaultOptions("keyStorePassword", "1.3.0", "Password for the client certificate keyStore (similar to java System property \"javax.net.ssl.keyStorePassword\").(legacy alias clientCertificateKeyStorePassword)", false);
    public static final /* enum */ DefaultOptions PRIVATE_KEYS_PASSWORD = new DefaultOptions("keyPassword", "1.5.3", "Password for the private key in client certificate keyStore. (only needed if private key password differ from keyStore password).", false);
    public static final /* enum */ DefaultOptions ENABLED_SSL_PROTOCOL_SUITES = new DefaultOptions("enabledSslProtocolSuites", "1.5.0", "Force TLS/SSL protocol to a specific set of TLS versions (comma separated list). \nExample : \"TLSv1, TLSv1.1, TLSv1.2\"\n(Alias \"enabledSSLProtocolSuites\" works too)", false);
    public static final /* enum */ DefaultOptions ENABLED_SSL_CIPHER_SUITES = new DefaultOptions("enabledSslCipherSuites", "1.5.0", "Force TLS/SSL cipher (comma separated list).\nExample : \"TLS_DHE_RSA_WITH_AES_256_GCM_SHA384, TLS_DHE_DSS_WITH_AES_256_GCM_SHA384\"", false);
    public static final /* enum */ DefaultOptions CONTINUE_BATCH_ON_ERROR = new DefaultOptions("continueBatchOnError", Boolean.TRUE, "1.4.0", "When executing batch queries, must batch continue on error.", false);
    public static final /* enum */ DefaultOptions JDBC_COMPLIANT_TRUNCATION = new DefaultOptions("jdbcCompliantTruncation", Boolean.TRUE, "1.4.0", "Truncation error (\"Data truncated for column '%' at row %\", \"Out of range value for column '%' at row %\") will be thrown as error, and not as warning.", false);
    public static final /* enum */ DefaultOptions CACHE_CALLABLE_STMTS = new DefaultOptions("cacheCallableStmts", Boolean.TRUE, "1.4.0", "enable/disable callable Statement cache, default true.", false);
    public static final /* enum */ DefaultOptions CALLABLE_STMT_CACHE_SIZE = new DefaultOptions("callableStmtCacheSize", 150, (Integer)0, "1.4.0", "This sets the number of callable statements that the driver will cache per VM if \"cacheCallableStmts\" is enabled.", false);
    public static final /* enum */ DefaultOptions CONNECTION_ATTRIBUTES = new DefaultOptions("connectionAttributes", "1.4.0", "When performance_schema is active, permit to send server some client information in a key;value pair format (example: connectionAttributes=key1:value1,key2,value2).\nThose informations can be retrieved on server within tables performance_schema.session_connect_attrs and performance_schema.session_account_connect_attrs.\nThis can permit from server an identification of client/application", false);
    public static final /* enum */ DefaultOptions USE_BATCH_MULTI_SEND = new DefaultOptions("useBatchMultiSend", (Boolean)null, "1.5.0", "*Not compatible with aurora*\nDriver will can send queries by batch. \nIf set to false, queries are sent one by one, waiting for the result before sending the next one. \nIf set to true, queries will be sent by batch corresponding to the useBatchMultiSendNumber option value (default 100) or according to the max_allowed_packet server variable if the packet size does not permit sending as many queries. Results will be read later, avoiding a lot of network latency when the client and server aren't on the same host. \n\nThis option is mainly effective when the client is distant from the server.", false);
    public static final /* enum */ DefaultOptions USE_BATCH_MULTI_SEND_NUMBER = new DefaultOptions("useBatchMultiSendNumber", 100, (Integer)1, "1.5.0", "When option useBatchMultiSend is active, indicate the maximum query send in a row before reading results.", false);
    public static final /* enum */ DefaultOptions LOGGING = new DefaultOptions("log", Boolean.FALSE, "1.5.0", "Enable log information. \nrequire Slf4j version > 1.4 dependency.\nLog level correspond to Slf4j logging implementation", false);
    public static final /* enum */ DefaultOptions PROFILE_SQL = new DefaultOptions("profileSql", Boolean.FALSE, "1.5.0", "log query execution time.", false);
    public static final /* enum */ DefaultOptions MAX_QUERY_LOG_SIZE = new DefaultOptions("maxQuerySizeToLog", 1024, (Integer)0, "1.5.0", "Max query log size.", false);
    public static final /* enum */ DefaultOptions SLOW_QUERY_TIME = new DefaultOptions("slowQueryThresholdNanos", null, 0L, "1.5.0", "Will log query with execution time superior to this value (if defined )", false);
    public static final /* enum */ DefaultOptions PASSWORD_CHARACTER_ENCODING = new DefaultOptions("passwordCharacterEncoding", "1.5.9", "Indicate password encoding charset. If not set, driver use platform's default charset.", false);
    public static final /* enum */ DefaultOptions PIPELINE_AUTH = new DefaultOptions("usePipelineAuth", (Boolean)null, "1.6.0", "*Not compatible with aurora*\nDuring connection, different queries are executed. When option is active those queries are send using pipeline (all queries are send, then only all results are reads), permitting faster connection creation", false);
    public static final /* enum */ DefaultOptions ENABLE_PACKET_DEBUG = new DefaultOptions("enablePacketDebug", Boolean.FALSE, "1.6.0", "Driver will save the last 16 MariaDB packet exchanges (limited to first 1000 bytes). Hexadecimal value of those packets will be added to stacktrace when an IOException occur.\nThis option has no impact on performance but driver will then take 16kb more memory.", false);
    public static final /* enum */ DefaultOptions SSL_HOSTNAME_VERIFICATION = new DefaultOptions("disableSslHostnameVerification", Boolean.FALSE, "2.1.0", "When using ssl, the driver checks the hostname against the server's identity as presented in the server's certificate (checking alternative names or the certificate CN) to prevent man-in-the-middle attacks. This option permits deactivating this validation. Hostname verification is disabled when the trustServerCertificate option is set", false);
    public static final /* enum */ DefaultOptions USE_BULK_PROTOCOL = new DefaultOptions("useBulkStmts", Boolean.FALSE, "2.1.0", "Use dedicated COM_STMT_BULK_EXECUTE protocol for batch insert when possible. (batch without Statement.RETURN_GENERATED_KEYS and streams) to have faster batch. (significant only if server MariaDB >= 10.2.7)", false);
    public static final /* enum */ DefaultOptions AUTOCOMMIT = new DefaultOptions("autocommit", Boolean.TRUE, "2.2.0", "Set default autocommit value on connection initialization", false);
    public static final /* enum */ DefaultOptions POOL = new DefaultOptions("pool", Boolean.FALSE, "2.2.0", "Use pool. This option is useful only if not using a DataSource object, but only a connection object.", false);
    public static final /* enum */ DefaultOptions POOL_NAME = new DefaultOptions("poolName", "2.2.0", "Pool name that permits identifying threads. default: auto-generated as MariaDb-pool-<pool-index>", false);
    public static final /* enum */ DefaultOptions MAX_POOL_SIZE = new DefaultOptions("maxPoolSize", 8, (Integer)1, "2.2.0", "The maximum number of physical connections that the pool should contain.", false);
    public static final /* enum */ DefaultOptions MIN_POOL_SIZE = new DefaultOptions("minPoolSize", (Integer)null, (Integer)0, "2.2.0", "When connections are removed due to not being used for longer than than \"maxIdleTime\", connections are closed and removed from the pool. \"minPoolSize\" indicates the number of physical connections the pool should keep available at all times. Should be less or equal to maxPoolSize.", false);
    public static final /* enum */ DefaultOptions MAX_IDLE_TIME = new DefaultOptions("maxIdleTime", 600, (Integer)60, "2.2.0", "The maximum amount of time in seconds that a connection can stay in the pool when not used. This value must always be below @wait_timeout value - 45s \nDefault: 600 in seconds (=10 minutes), minimum value is 60 seconds", false);
    public static final /* enum */ DefaultOptions POOL_VALID_MIN_DELAY = new DefaultOptions("poolValidMinDelay", 1000, (Integer)0, "2.2.0", "When asking a connection to pool, the pool will validate the connection state. \"poolValidMinDelay\" permits disabling this validation if the connection has been borrowed recently avoiding useless verifications in case of frequent reuse of connections. 0 means validation is done each time the connection is asked.", false);
    public static final /* enum */ DefaultOptions STATIC_GLOBAL = new DefaultOptions("staticGlobal", Boolean.FALSE, "2.2.0", "Indicates the values of the global variables max_allowed_packet, wait_timeout, autocommit, auto_increment_increment, time_zone, system_time_zone and tx_isolation) won't be changed, permitting the pool to create new connections faster.", false);
    public static final /* enum */ DefaultOptions REGISTER_POOL_JMX = new DefaultOptions("registerJmxPool", Boolean.TRUE, "2.2.0", "Register JMX monitoring pools.", false);
    public static final /* enum */ DefaultOptions USE_RESET_CONNECTION = new DefaultOptions("useResetConnection", Boolean.FALSE, "2.2.0", "When a connection is closed() (given back to pool), the pool resets the connection state. Setting this option, the prepare command will be deleted, session variables changed will be reset, and user variables will be destroyed when the server permits it (>= MariaDB 10.2.4, >= MySQL 5.7.3), permitting saving memory on the server if the application make extensive use of variables. Must not be used with the useServerPrepStmts option", false);
    public static final /* enum */ DefaultOptions ALLOW_MASTER_DOWN = new DefaultOptions("allowMasterDownConnection", Boolean.FALSE, "2.2.0", "When using master/slave configuration, permit to create connection when master is down. If no master is up, default connection is then a slave and Connection.isReadOnly() will then return true.", false);
    public static final /* enum */ DefaultOptions GALERA_ALLOWED_STATE = new DefaultOptions("galeraAllowedState", "2.2.5", "Usually, Connection.isValid just send an empty packet to server, and server send a small response to ensure connectivity. When this option is set, connector will ensure Galera server state \"wsrep_local_state\" correspond to allowed values (separated by comma). Example \"4,5\", recommended is \"4\". see galera state to know more.", false);
    public static final /* enum */ DefaultOptions USE_AFFECTED_ROWS = new DefaultOptions("useAffectedRows", Boolean.FALSE, "2.3.0", "If false (default), use \"found rows\" for the row count of statements. This corresponds to the JDBC standard.\nIf true, use \"affected rows\" for the row count.\nThis changes the behavior of, for example, UPDATE... ON DUPLICATE KEY statements.", false);
    public static final /* enum */ DefaultOptions INCLUDE_STATUS = new DefaultOptions("includeInnodbStatusInDeadlockExceptions", Boolean.FALSE, "2.3.0", "add \"SHOW ENGINE INNODB STATUS\" result to exception trace when having a deadlock exception", false);
    public static final /* enum */ DefaultOptions INCLUDE_THREAD_DUMP = new DefaultOptions("includeThreadDumpInDeadlockExceptions", Boolean.FALSE, "2.3.0", "add thread dump to exception trace when having a deadlock exception", false);
    public static final /* enum */ DefaultOptions READ_AHEAD = new DefaultOptions("useReadAheadInput", Boolean.TRUE, "2.4.0", "use a buffered inputSteam that read socket available data", false);
    public static final /* enum */ DefaultOptions KEY_STORE_TYPE = new DefaultOptions("keyStoreType", (String)null, "2.4.0", "indicate key store type (JKS/PKCS12). default is null, then using java default type", false);
    public static final /* enum */ DefaultOptions TRUST_STORE_TYPE = new DefaultOptions("trustStoreType", (String)null, "2.4.0", "indicate trust store type (JKS/PKCS12). default is null, then using java default type", false);
    public static final /* enum */ DefaultOptions SERVICE_PRINCIPAL_NAME = new DefaultOptions("servicePrincipalName", (String)null, "2.4.0", "when using GSSAPI authentication, SPN (Service Principal Name) use the server SPN information. When set, connector will use this value, ignoring server information", false);
    public static final /* enum */ DefaultOptions DEFAULT_FETCH_SIZE = new DefaultOptions("defaultFetchSize", 0, (Integer)0, "2.4.2", "The driver will call setFetchSize(n) with this value on all newly-created Statements", false);
    public static final /* enum */ DefaultOptions USE_MYSQL_AS_DATABASE = new DefaultOptions("useMysqlMetadata", Boolean.FALSE, "2.4.1", "force DatabaseMetadata.getDatabaseProductName() to return \"MySQL\" as database, not real database type", false);
    public static final /* enum */ DefaultOptions BLANK_TABLE_NAME_META = new DefaultOptions("blankTableNameMeta", Boolean.FALSE, "2.4.3", "Resultset metadata getTableName always return blank. This option is mainly for ORACLE db compatibility", false);
    private final String optionName;
    private final String description;
    private final boolean required;
    private final Object objType;
    private final Object defaultValue;
    private final Object minValue;
    private final Object maxValue;
    private static final /* synthetic */ DefaultOptions[] $VALUES;

    public static DefaultOptions[] values() {
        return (DefaultOptions[])$VALUES.clone();
    }

    public static DefaultOptions valueOf(String name) {
        return Enum.valueOf(DefaultOptions.class, name);
    }

    private DefaultOptions(String optionName, String implementationVersion, String description, boolean required) {
        this.optionName = optionName;
        this.description = description;
        this.required = required;
        this.objType = String.class;
        this.defaultValue = null;
        this.minValue = null;
        this.maxValue = null;
    }

    private DefaultOptions(String optionName, String defaultValue, String implementationVersion, String description, boolean required) {
        this.optionName = optionName;
        this.description = description;
        this.required = required;
        this.objType = String.class;
        this.defaultValue = defaultValue;
        this.minValue = null;
        this.maxValue = null;
    }

    private DefaultOptions(String optionName, Boolean defaultValue, String implementationVersion, String description, boolean required) {
        this.optionName = optionName;
        this.objType = Boolean.class;
        this.defaultValue = defaultValue;
        this.description = description;
        this.required = required;
        this.minValue = null;
        this.maxValue = null;
    }

    private DefaultOptions(String optionName, Integer defaultValue, Integer minValue, String implementationVersion, String description, boolean required) {
        this.optionName = optionName;
        this.objType = Integer.class;
        this.defaultValue = defaultValue;
        this.minValue = minValue;
        this.maxValue = Integer.MAX_VALUE;
        this.description = description;
        this.required = required;
    }

    private DefaultOptions(String optionName, Long defaultValue, Long minValue, String implementationVersion, String description, boolean required) {
        this.optionName = optionName;
        this.objType = Long.class;
        this.defaultValue = defaultValue;
        this.minValue = minValue;
        this.maxValue = Long.MAX_VALUE;
        this.description = description;
        this.required = required;
    }

    private DefaultOptions(String optionName, Integer[] defaultValue, Integer minValue, String implementationVersion, String description, boolean required) {
        this.optionName = optionName;
        this.objType = Integer.class;
        this.defaultValue = defaultValue;
        this.minValue = minValue;
        this.maxValue = Integer.MAX_VALUE;
        this.description = description;
        this.required = required;
    }

    public static Options defaultValues(HaMode haMode) {
        return DefaultOptions.parse(haMode, "", new Properties());
    }

    public static Options defaultValues(HaMode haMode, boolean pool) {
        Properties properties = new Properties();
        properties.setProperty("pool", String.valueOf(pool));
        Options options = DefaultOptions.parse(haMode, "", properties);
        DefaultOptions.optionCoherenceValidation(options);
        return options;
    }

    public static void parse(HaMode haMode, String urlParameters, Options options) {
        Properties prop = new Properties();
        DefaultOptions.parse(haMode, urlParameters, prop, options);
        DefaultOptions.optionCoherenceValidation(options);
    }

    private static Options parse(HaMode haMode, String urlParameters, Properties properties) {
        Options options = DefaultOptions.parse(haMode, urlParameters, properties, null);
        DefaultOptions.optionCoherenceValidation(options);
        return options;
    }

    public static Options parse(HaMode haMode, String urlParameters, Properties properties, Options options) {
        if (urlParameters != null && !urlParameters.isEmpty()) {
            String[] parameters;
            for (String parameter : parameters = urlParameters.split("&")) {
                int pos = parameter.indexOf(61);
                if (pos == -1) {
                    if (properties.containsKey(parameter)) continue;
                    properties.setProperty(parameter, "");
                    continue;
                }
                if (properties.containsKey(parameter.substring(0, pos))) continue;
                properties.setProperty(parameter.substring(0, pos), parameter.substring(pos + 1));
            }
        }
        return DefaultOptions.parse(haMode, properties, options);
    }

    private static Options parse(HaMode haMode, Properties properties, Options paramOptions) {
        Options options = paramOptions != null ? paramOptions : new Options();
        try {
            for (String key : properties.stringPropertyNames()) {
                Number value;
                String propertyValue = properties.getProperty(key);
                DefaultOptions o = OptionUtils.OPTIONS_MAP.get(key);
                if (o == null || propertyValue == null) continue;
                Field field = Options.class.getField(o.optionName);
                if (o.objType.equals(String.class)) {
                    field.set(options, propertyValue);
                    continue;
                }
                if (o.objType.equals(Boolean.class)) {
                    switch (propertyValue.toLowerCase()) {
                        case "": 
                        case "1": 
                        case "true": {
                            field.set(options, Boolean.TRUE);
                            break;
                        }
                        case "0": 
                        case "false": {
                            field.set(options, Boolean.FALSE);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Optional parameter " + o.optionName + " must be boolean (true/false or 0/1) was \"" + propertyValue + "\"");
                        }
                    }
                    continue;
                }
                if (o.objType.equals(Integer.class)) {
                    try {
                        value = Integer.parseInt(propertyValue);
                        assert (o.minValue != null);
                        assert (o.maxValue != null);
                        if (((Integer)value).compareTo((Integer)o.minValue) < 0 || ((Integer)value).compareTo((Integer)o.maxValue) > 0) {
                            throw new IllegalArgumentException("Optional parameter " + o.optionName + " must be greater or equal to " + o.minValue + ((Integer)o.maxValue != Integer.MAX_VALUE ? " and smaller than " + o.maxValue : " ") + ", was \"" + propertyValue + "\"");
                        }
                        field.set(options, value);
                        continue;
                    }
                    catch (NumberFormatException n) {
                        throw new IllegalArgumentException("Optional parameter " + o.optionName + " must be Integer, was \"" + propertyValue + "\"");
                    }
                }
                if (!o.objType.equals(Long.class)) continue;
                try {
                    value = Long.parseLong(propertyValue);
                    assert (o.minValue != null);
                    assert (o.maxValue != null);
                    if (((Long)value).compareTo((Long)o.minValue) < 0 || ((Long)value).compareTo((Long)o.maxValue) > 0) {
                        throw new IllegalArgumentException("Optional parameter " + o.optionName + " must be greater or equal to " + o.minValue + ((Long)o.maxValue != Long.MAX_VALUE ? " and smaller than " + o.maxValue : " ") + ", was \"" + propertyValue + "\"");
                    }
                    field.set(options, value);
                }
                catch (NumberFormatException n) {
                    throw new IllegalArgumentException("Optional parameter " + o.optionName + " must be Long, was \"" + propertyValue + "\"");
                }
            }
            if (options.socketTimeout == null) {
                options.socketTimeout = ((Integer[])DefaultOptions.SOCKET_TIMEOUT.defaultValue)[haMode.ordinal()];
            }
        }
        catch (IllegalAccessException | NoSuchFieldException n) {
            n.printStackTrace();
        }
        catch (SecurityException s) {
            throw new IllegalArgumentException("Security too restrictive : " + s.getMessage());
        }
        return options;
    }

    public static void optionCoherenceValidation(Options options) {
        if (options.rewriteBatchedStatements) {
            options.useServerPrepStmts = false;
        }
        if (options.pipe != null) {
            options.useBatchMultiSend = false;
            options.usePipelineAuth = false;
        }
        if (options.pool) {
            options.minPoolSize = options.minPoolSize == null ? options.maxPoolSize : Math.min(options.minPoolSize, options.maxPoolSize);
        }
        if (options.defaultFetchSize < 0) {
            options.defaultFetchSize = 0;
        }
    }

    public static void propertyString(Options options, HaMode haMode, StringBuilder sb) {
        try {
            boolean first = true;
            for (DefaultOptions o : DefaultOptions.values()) {
                Object value = Options.class.getField(o.optionName).get(options);
                if (value == null || value.equals(o.defaultValue)) continue;
                if (first) {
                    first = false;
                    sb.append('?');
                } else {
                    sb.append('&');
                }
                sb.append(o.optionName).append('=');
                if (o.objType.equals(String.class)) {
                    sb.append((String)value);
                    continue;
                }
                if (o.objType.equals(Boolean.class)) {
                    sb.append(((Boolean)value).toString());
                    continue;
                }
                if (!o.objType.equals(Integer.class) && !o.objType.equals(Long.class)) continue;
                sb.append(value);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException n) {
            n.printStackTrace();
        }
    }

    public String getOptionName() {
        return this.optionName;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isRequired() {
        return this.required;
    }

    static {
        $VALUES = new DefaultOptions[]{USER, PASSWORD, CONNECT_TIMEOUT, PIPE, LOCAL_SOCKET, SHARED_MEMORY, TCP_NO_DELAY, TCP_ABORTIVE_CLOSE, LOCAL_SOCKET_ADDRESS, SOCKET_TIMEOUT, INTERACTIVE_CLIENT, DUMP_QUERY_ON_EXCEPTION, USE_OLD_ALIAS_METADATA_BEHAVIOR, ALLOW_LOCAL_INFILE, SESSION_VARIABLES, CREATE_DATABASE_IF_NOT_EXISTS, SERVER_TIMEZONE, NULL_CATALOG_MEANS_CURRENT, TINY_INT_IS_BIT, YEAR_IS_DATE_TYPE, USE_SSL, USER_COMPRESSION, ALLOW_MULTI_QUERIES, REWRITE_BATCHED_STATEMENTS, TCP_KEEP_ALIVE, TCP_RCV_BUF, TCP_SND_BUF, SOCKET_FACTORY, PIN_GLOBAL_TX_TO_PHYSICAL_CONNECTION, TRUST_SERVER_CERTIFICATE, SERVER_SSL_CERT, USE_FRACTIONAL_SECONDS, AUTO_RECONNECT, FAIL_ON_READ_ONLY, RETRY_ALL_DOWN, FAILOVER_LOOP_RETRIES, VALID_CONNECTION_TIMEOUT, LOAD_BALANCE_BLACKLIST_TIMEOUT, CACHE_PREP_STMTS, PREP_STMT_CACHE_SIZE, PREP_STMT_CACHE_SQL_LIMIT, ASSURE_READONLY, USE_LEGACY_DATETIME_CODE, MAXIMIZE_MYSQL_COMPATIBILITY, USE_SERVER_PREP_STMTS, TRUSTSTORE, TRUST_CERTIFICATE_KEYSTORE_PASSWORD, KEYSTORE, KEYSTORE_PASSWORD, PRIVATE_KEYS_PASSWORD, ENABLED_SSL_PROTOCOL_SUITES, ENABLED_SSL_CIPHER_SUITES, CONTINUE_BATCH_ON_ERROR, JDBC_COMPLIANT_TRUNCATION, CACHE_CALLABLE_STMTS, CALLABLE_STMT_CACHE_SIZE, CONNECTION_ATTRIBUTES, USE_BATCH_MULTI_SEND, USE_BATCH_MULTI_SEND_NUMBER, LOGGING, PROFILE_SQL, MAX_QUERY_LOG_SIZE, SLOW_QUERY_TIME, PASSWORD_CHARACTER_ENCODING, PIPELINE_AUTH, ENABLE_PACKET_DEBUG, SSL_HOSTNAME_VERIFICATION, USE_BULK_PROTOCOL, AUTOCOMMIT, POOL, POOL_NAME, MAX_POOL_SIZE, MIN_POOL_SIZE, MAX_IDLE_TIME, POOL_VALID_MIN_DELAY, STATIC_GLOBAL, REGISTER_POOL_JMX, USE_RESET_CONNECTION, ALLOW_MASTER_DOWN, GALERA_ALLOWED_STATE, USE_AFFECTED_ROWS, INCLUDE_STATUS, INCLUDE_THREAD_DUMP, READ_AHEAD, KEY_STORE_TYPE, TRUST_STORE_TYPE, SERVICE_PRINCIPAL_NAME, DEFAULT_FETCH_SIZE, USE_MYSQL_AS_DATABASE, BLANK_TABLE_NAME_META};
    }
}

